/******************************************************************************
 * The following code was generated by the mental mill(R)                     *
 * code generator gen_fx, build 138747.21028
 *                                                                            *
 * Portions Copyright (c) 1986-2011 mental images GmbH, Berlin, Germany.      *
 ******************************************************************************/

// Option settings:
//	annotation_map : default.axml
//	depth_test : false
//	depth_write : false
//	directx_version : 11
//	flip_tex2d_v : false
//	format : HLSL
//	fragment_shader_profile : ps_5_0
//	fx_header : #ifdef _MAX_...
//	generate_sampler_states : true
//	generate_texture_parameters : true
//	pass_annotations : string Script = "Draw=Buffer;";
//	screen_space_vertices : true
//	shader_name : max_ToneOpPseudo_1
//	shader_type : surface
//	technique_annotations : string Script = "Pass=P0;";
//	vertex_shader_profile : vs_5_0

#ifdef _MAX_
string ParamID = "0x003";
#endif

float Script : STANDARDSGLOBAL <
	string UIWidget = "none";
	string ScriptClass = "scene";
	string ScriptOutput = "color";
	string Script = "Technique=T0";
> = 0.8; // version #

struct State {
    float4 tex_coord[4];
    float3 position;
    float3 origin;
    float3 normal;
    float3 direction;
    float ray_length;
};

#ifndef __LIGHT_TYPES
#define __LIGHT_TYPES
//
// Values for the light_type parameter of light shaders
//
#define LIGHT_POINT    0
#define LIGHT_SPOT     1
#define LIGHT_INFINITE 2
#define LIGHT_PLANAR   3

#endif // __LIGHT_TYPES

#ifndef __LIGHT_ITERATOR_STRUCT
#define __LIGHT_ITERATOR_STRUCT
struct Light_iterator {
    float3 msl_point;
    float3 msl_direction;
    float  msl_distance;
    float  msl_dot_nl;
    float3 msl_contribution;
    float3 msl_raw_contribution;
    float3 msl_shadow;
    int    msl_count;
};
#endif // __LIGHT_ITERATOR_STRUCT

#ifndef __FLOAT2_CTOR
#define __FLOAT2_CTOR
float2 __float2_ctor(float v)
{
    return v.xx;
}

#endif // __FLOAT2_CTOR

#ifndef __FLOAT3_CTOR
#define __FLOAT3_CTOR
float3 __float3_ctor(float v)
{
    return v.xxx;
}

#endif // __FLOAT3_CTOR

#ifndef __FLOAT4_CTOR
#define __FLOAT4_CTOR
float4 __float4_ctor(float v)
{
    return v.xxxx;
}

#endif // __FLOAT4_CTOR

#ifndef __DIFFERENTIAL_SCALE
#define __DIFFERENTIAL_SCALE
uniform float __differential_scale = 1.0;

#endif // __DIFFERENTIAL_SCALE

#ifndef __RASTER_OFFSET
#define __RASTER_OFFSET
uniform float2 __raster_offset = float2(0,0);

#endif // __RASTER_OFFSET

int3 _coord_to_texel(float4 props, float2 coord)
{
    return int3(floor(props.xy * coord) + 0.5,0);
}

#ifndef __TEXTURE2D
#define __TEXTURE2D

float4 __tex2D(Texture2D <float4> tex, SamplerState smp, float2 coord)
{
    return tex.SampleGrad(smp, coord,
                   __differential_scale * ddx(coord),
                   __differential_scale * ddy(coord));
}

float4 __tex2D(Texture2D <float4> tex, SamplerState smp, float2 coord,float2 coord_dx, float2 coord_dy)
{
    return tex.SampleGrad(smp, coord, coord_dx, coord_dy);
}

float4 __tex2D(Texture2D <float4> tex, SamplerState smp, float4 props, float2 coord, float2 blur)
{
    return tex.SampleGrad(smp, coord,
                   __differential_scale * ddx(coord) * blur,
                   __differential_scale * ddy(coord) * blur);
}

float4 __tex2D(Texture2D <float4> tex, SamplerState smp, float4 props, float2 coord, float2 blur, int filter)
{
    if(filter == 6)
        return tex.Load(_coord_to_texel(props, coord));
    else
        return tex.SampleGrad(smp, coord,
                   __differential_scale * ddx(coord) * blur,
                   __differential_scale * ddy(coord) * blur);
}

float4 __tex2D(Texture2D <float4> tex, SamplerState smp, float4 props, float2 coord, float2 coord_dx, float2 coord_dy, float2 blur)
{
    return tex.SampleGrad(smp, coord,
                   coord_dx * blur,
                   coord_dy * blur);
}

float4 __tex2D(Texture2D <float4> tex, SamplerState smp, float4 props, float2 coord, float2 coord_dx, float2 coord_dy, float2 blur, int filter)
{
    if(filter == 6)
        return tex.Load(_coord_to_texel(props, coord));
    else
        return tex.SampleGrad(smp, coord,
                       coord_dx * blur,
                       coord_dy * blur);
}

#endif // __TEXTURE2D

#ifndef __MAKE_BASIS
#define __MAKE_BASIS
void __make_basis(const float3 n,const float3 u,const float3 v,out float3 t,out float3 b)
{
    // If u or v a 0, we could create NaNs, try to avoid this.
    float3 c = cross(u,n);
    if(dot(c,c) == 0.0) {
        c = cross(float3(0.0,1.0,0.0),n);
        if(dot(c,c) == 0.0) {
            c = cross(float3(1.0,0.0,0.0), n);
        }
    }
    b = normalize(c);
    t = cross(n,b);
    if(dot(b,v) < 0.0)
        b = -b;
}

#endif // __MAKE_BASIS

#ifndef __PERSPECTIVE_DIVIDE
#define __PERSPECTIVE_DIVIDE
float3 __perspective_divide(float4 pt)
{
    return pt.xyz / pt.w;
}

#endif // __PERSPECTIVE_DIVIDE

#ifndef __DEPENDENT_STATE
#define __DEPENDENT_STATE
void __update_state_origin_or_position(inout State state)
{
    state.direction = state.position - state.origin;
    state.ray_length = length(state.direction);
    state.direction = normalize(state.direction);
} 

#endif // __DEPENDENT_STATE

#ifndef __OBJECT_LABELS
#define __OBJECT_LABELS
uniform int __object_label = 0;
float4 _label_as_color()
{
    int n = __object_label;
    float4 c;
    c.a = float(n / 16777216);
    c.b = float((n % 16777216) / 65536);
    c.g = float((n % 65536) / 256);
    c.r = float(n % 256);
    c /= 255.0;
    return c;
} 

#endif // __OBJECT_LABELS

#ifndef __CLIP_PLANE
#define __CLIP_PLANE
uniform float4 __clip_plane = float4(1.0,1.0,0.0,0.0);

#endif // __CLIP_PLANE

#ifndef __BIT_COUNT
#define __BIT_COUNT
int __bit_count(uint a) {
    int res = 0;
    if (a >= 0x8000) { a -= 0x8000; ++res; }
    if (a >= 0x4000) { a -= 0x4000; ++res; }
    if (a >= 0x2000) { a -= 0x2000; ++res; }
    if (a >= 0x1000) { a -= 0x1000; ++res; }
    if (a >= 0x0800) { a -= 0x0800; ++res; }
    if (a >= 0x0400) { a -= 0x0400; ++res; }
    if (a >= 0x0200) { a -= 0x0200; ++res; }
    if (a >= 0x0100) { a -= 0x0100; ++res; }
    if (a >= 0x8000) { a -= 0x8000; ++res; }
    if (a >= 0x0040) { a -= 0x0040; ++res; }
    if (a >= 0x0020) { a -= 0x0020; ++res; }
    if (a >= 0x0010) { a -= 0x0010; ++res; }
    if (a >= 0x0008) { a -= 0x0008; ++res; }
    if (a >= 0x0004) { a -= 0x0004; ++res; }
    if (a >= 0x0002) { a -= 0x0002; ++res; }
    if (a >= 0x0001) {              ++res; }
    return res;
}
#endif // __BIT_COUNT


//
// The following are free parameters of the shader
// that should be set by the application at runtime.
//
Texture2D <float4> __msl_max_ToneOpPseudo_1_env_tex <
    string NodeName = "max_ToneOpPseudo_1";
    string UIMetaSLName = "env_tex";
    string parameter_source = "max_ToneOpPseudo_1";
	string UIName = "msl_max_ToneOpPseudo_1_env_tex";
	string ResourceName = "max_ToneOpPseudo.exr";
	string ResourceType = "2D";
>;

SamplerState __msl_max_ToneOpPseudo_1_env_tex_sampler {
	Filter = MIN_MAG_MIP_POINT;
	AddressU = Wrap;
	AddressV = Wrap;
	AddressW = Wrap;
};

float4 msl_max_ToneOpPseudo_1_env_tex_props;

bool msl_max_ToneOpPseudo_1_active
<
    string UIName = "Active";
    string NodeName = "max_ToneOpPseudo_1";
    string UIMetaSLName = "active";
    string parameter_source = "max_ToneOpPseudo_1";
> = true;
float msl_max_ToneOpPseudo_1_minimum
<
    string UIName = "Minimum";
    float UIMin = 0.0f;
    float UIMax = 10000.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_ToneOpPseudo_1";
    string UIMetaSLName = "minimum";
    string parameter_source = "max_ToneOpPseudo_1";
> = 0.0f;
float msl_max_ToneOpPseudo_1_maximum
<
    string UIName = "Maximum";
    float UIMin = 0.0f;
    float UIMax = 10000.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_ToneOpPseudo_1";
    string UIMetaSLName = "maximum";
    string parameter_source = "max_ToneOpPseudo_1";
> = 10000.0f;
int msl_max_ToneOpPseudo_1_quantity
<
    string UIName = "Quantity";
    int UIMin = 0;
    int UIMax = 1;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_ToneOpPseudo_1";
    string UIMetaSLName = "quantity";
    string parameter_source = "max_ToneOpPseudo_1";
> = 1;
int msl_max_ToneOpPseudo_1_display
<
    string UIName = "Display";
    int UIMin = 0;
    int UIMax = 2;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_ToneOpPseudo_1";
    string UIMetaSLName = "display";
    string parameter_source = "max_ToneOpPseudo_1";
> = 0;
float msl_max_ToneOpPseudo_1_physicalscale
<
    string UIName = "Physical Scale";
    float UIMin = 1.0f;
    float UIMax = 3000.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_ToneOpPseudo_1";
    string UIMetaSLName = "physicalscale";
    string parameter_source = "max_ToneOpPseudo_1";
> = 1500.0f;
int msl_max_ToneOpPseudo_1_scalefunction
<
    string UIName = "Scale Function";
    int UIMin = 0;
    int UIMax = 1;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_ToneOpPseudo_1";
    string UIMetaSLName = "scalefunction";
    string parameter_source = "max_ToneOpPseudo_1";
> = 1;
int msl_max_ToneOpPseudo_1_unitsystemused
<
    string UIName = "Unit System Used";
    int UIMin = 0;
    int UIMax = 2;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_ToneOpPseudo_1";
    string UIMetaSLName = "unitsystemused";
    string parameter_source = "max_ToneOpPseudo_1";
> = 0;
int msl_max_ToneOpPseudo_1_nbcolors
<
    string UIName = "Number Of Colors";
    string NodeName = "max_ToneOpPseudo_1";
    string UIMetaSLName = "nbcolors";
    string parameter_source = "max_ToneOpPseudo_1";
> = 100;
/*
	max_ToneOpPseudo_1_active:
		bool msl_max_ToneOpPseudo_1_active = true
	max_ToneOpPseudo_1_display:
		int msl_max_ToneOpPseudo_1_display = 0
	max_ToneOpPseudo_1_maximum:
		float msl_max_ToneOpPseudo_1_maximum = 10000.000000
	max_ToneOpPseudo_1_minimum:
		float msl_max_ToneOpPseudo_1_minimum = 0.000000
	max_ToneOpPseudo_1_nbcolors:
		int msl_max_ToneOpPseudo_1_nbcolors = 100
	max_ToneOpPseudo_1_physicalscale:
		float msl_max_ToneOpPseudo_1_physicalscale = 1500.000000
	max_ToneOpPseudo_1_quantity:
		int msl_max_ToneOpPseudo_1_quantity = 1
	max_ToneOpPseudo_1_scalefunction:
		int msl_max_ToneOpPseudo_1_scalefunction = 1
	max_ToneOpPseudo_1_unitsystemused:
		int msl_max_ToneOpPseudo_1_unitsystemused = 0
 */


//
// The following are parameters representing
// non-varying state variables referenced by the shader.
// These should be set by the application at runtime.
//

float4x4 __ndc_to_camera : ProjectionInverse
<
    string UIWidget = "none";
>;
float4x4 __camera_to_ndc : Projection
<
    string UIWidget = "none";
>;
bool __orthographic : Orthographic= false;
float4x4 __object_to_world : World
<
    string UIWidget = "none";
>;
float4x4 __camera_to_world : ViewInverse
<
    string UIWidget = "none";
>;

//
// The following are parameters representing
// non-varying non-state variables referenced by the shader.
// These should be set by the application at runtime.
//
float4x4 __internal_to_light;
float4x4 __light_to_internal;
float4 __light_texture_coordinate[4];
float3 __light_texture_tangent_u[4];
float3 __light_texture_tangent_v[4];
float __wavelength_base[3];
float __wavelength_sample[3];
int __light_normal_mode;
float __light_scaling_factor;


//
// The App2vert structure defines the vertex attributes
// used by the vertex shader.
// The application should supply a vertex stream
// containing these elements.
//
struct App2vert
{
    float3 position : POSITION;
    float3 normal : NORMAL;
    float4 texcoord0 : TEXCOORD0;
    float4 texcoord1 : TEXCOORD1;
    float4 texcoord2 : TEXCOORD2;
    float4 texcoord3 : TEXCOORD3;
};

//
// The Vert2frag_out structure defines values output by the vertex shader.
//
struct Vert2frag_out
{
    float4 hpos : SV_Position;
    float4 tex_coord[4] : TEXCOORD0;
    float3 position : TEXCOORD4;
    float3 normal : TEXCOORD5;
};

//
// The Vert2frag_in structure defines values used by the fragment shader.
//
struct Vert2frag_in
{
    float4 hpos : SV_Position;
    float4 tex_coord[4] : TEXCOORD0;
    float3 position : TEXCOORD4;
    float3 normal : TEXCOORD5;
};

//
// This function is the main method of the vertex shader.
//
Vert2frag_out vertex_main(
    App2vert vs_in)
{
    Vert2frag_out vs_out;
    vs_out.position = mul(float4(vs_in.position,1.0),__ndc_to_camera).xyz;
    vs_out.hpos = float4(vs_in.position,1.0);
    vs_out.normal = mul((float3x3)__camera_to_ndc,vs_in.normal);
    vs_out.tex_coord[0] = vs_in.texcoord0;
    vs_out.tex_coord[1] = vs_in.texcoord1;
    vs_out.tex_coord[2] = vs_in.texcoord2;
    vs_out.tex_coord[3] = vs_in.texcoord3;
    return vs_out;
}

//
// Declaration of final output type. For MRT, this is a struct.
//
typedef float4 FS_OUT;

float max_ToneOpPseudo_calcBrightness_4029_48(
    inout State state,
    in float4 msl_value)
{
    return ((abs(msl_value.r) * 0.263f) + (abs(msl_value.g) * 0.655f)) + (abs(msl_value.b) * 0.082f);
}

int max_ToneOpPseudo_max_ToneOpPseudo_ScaleToRGB_4029_50(
    inout State state,
    inout float4 msl_local_result,
    in float msl_param_physicalscale,
    in int msl_param_quantity,
    in float msl_data_minimum,
    in float msl_data_maximum,
    in int msl_param_scalefunction,
    in float msl_inst_cfA,
    in float msl_inst_cfB,
    in float msl_inst_conversionFactor,
    in int msl_inst_nbColors)
{
    float msl_brightness = max_ToneOpPseudo_calcBrightness_4029_48(state,msl_local_result) * msl_param_physicalscale;
    if(msl_param_quantity == 1)
    {
        msl_brightness /= 3.14159265358979323846f;
    }
    if(msl_brightness < msl_data_minimum)
    {
        msl_brightness = msl_data_minimum;
    }
    else
    {
        if(msl_brightness > msl_data_maximum)
        {
            msl_brightness = msl_data_maximum;
        }
    }
    int msl_i = 0;
    if(msl_param_scalefunction == 0)
    {
        msl_i = int(msl_inst_cfA * log10((msl_inst_cfB * (1.0f + msl_brightness))));
    }
    else
    {
        msl_i = int((msl_brightness - msl_data_minimum) * msl_inst_conversionFactor);
    }
    if(msl_i < 0)
    {
        msl_i = 0;
    }
    else
    {
        if(msl_i >= msl_inst_nbColors)
        {
            msl_i = (msl_inst_nbColors - 1);
        }
    }
    return msl_i;
}

int max_ToneOpPseudo_HSVtoRGB_4029_38(
    inout State state,
    in float4 msl_hsv,
    out float4 msl_res)
{
    msl_res = float4(0.0f,0.0f,0.0f,0.0f);
    float msl_h = 6.0f * msl_hsv.r;
    float msl_s = msl_hsv.g;
    int msl_I = int(msl_h);
    float msl_f = msl_h - float(msl_I);
    float msl_M = msl_hsv.b * (1.0f - msl_s);
    float msl_N = 0.0f;
    float msl_K = 0.0f;
    if(fmod(float(msl_I),2.0f) == 1.0f)
    {
        msl_N = (msl_hsv.b * (1.0f - (msl_s * msl_f)));
    }
    else
    {
        msl_K = (msl_hsv.b * (1.0f - (msl_s * (1.0f - msl_f))));
    }
    if((msl_I == 6) || (msl_I == 0))
    {
        msl_res.r = msl_hsv.b;
        msl_res.g = msl_K;
        msl_res.b = msl_M;
        msl_res.a = 1.0f;
    }
    else
    {
        if(msl_I == 1)
        {
            msl_res.r = msl_N;
            msl_res.g = msl_hsv.b;
            msl_res.b = msl_M;
            msl_res.a = 1.0f;
        }
        else
        {
            if(msl_I == 2)
            {
                msl_res.r = msl_M;
                msl_res.g = msl_hsv.b;
                msl_res.b = msl_K;
                msl_res.a = 1.0f;
            }
            else
            {
                if(msl_I == 3)
                {
                    msl_res.r = msl_M;
                    msl_res.g = msl_N;
                    msl_res.b = msl_hsv.b;
                    msl_res.a = 1.0f;
                }
                else
                {
                    if(msl_I == 4)
                    {
                        msl_res.r = msl_K;
                        msl_res.g = msl_M;
                        msl_res.b = msl_hsv.b;
                        msl_res.a = 1.0f;
                    }
                    else
                    {
                        if(msl_I == 5)
                        {
                            msl_res.r = msl_hsv.b;
                            msl_res.g = msl_M;
                            msl_res.b = msl_N;
                            msl_res.a = 1.0f;
                        }
                    }
                }
            }
        }
    }
    return 0;
}

int max_ToneOpPseudo_main_4029_11(
    inout State state,
    Texture2D <float4> __msl_env_tex, SamplerState __msl_env_tex_sampler, float4 msl_env_tex_props,
    float2 msl_texture_uv,
    bool msl_active,
    float msl_minimum,
    float msl_maximum,
    int msl_quantity,
    int msl_display,
    float msl_physicalscale,
    int msl_scalefunction,
    int msl_unitsystemused,
    int msl_nbcolors,
    out float4 msl_result)
{
    {
        msl_result = float4(0.0f,0.0f,0.0f,0.0f);
        float3 msl_v = mul((state.direction),(float3x3)(float4x4(1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1)));
        float2 msl_texture;
        msl_texture.x = (0.5f + msl_v.x);
        msl_texture.y = (0.5f - msl_v.y);
        msl_result = __tex2D(__msl_env_tex,__msl_env_tex_sampler,msl_texture_uv);
        if(msl_active)
        {
            float msl_inst_minimum_SI = msl_minimum;
            float msl_inst_maximum_SI = msl_maximum;
            if(msl_unitsystemused != 0)
            {
                msl_inst_minimum_SI *= 10.76391f;
                msl_inst_maximum_SI *= 10.76391f;
            }
            float msl_maxBrightness = msl_inst_maximum_SI;
            float msl_minBrightness = msl_inst_minimum_SI;
            float msl_inst_conversionFactor = (msl_maxBrightness > msl_minBrightness) ? (1.0f / (msl_maxBrightness - msl_minBrightness)) : 1.0f;
            msl_inst_conversionFactor *= float(msl_nbcolors);
            float msl_inst_cfB = 1.0f / (1.0f + msl_minBrightness);
            float msl_inst_cfA = float(msl_nbcolors);
            if(msl_maxBrightness > msl_minBrightness)
            {
                msl_inst_cfA /= log10(((1.0f + msl_maxBrightness) / (1.0f + msl_minBrightness)));
            }
            int msl_index = max_ToneOpPseudo_max_ToneOpPseudo_ScaleToRGB_4029_50(state,msl_result,msl_physicalscale,msl_quantity,msl_inst_minimum_SI,msl_inst_maximum_SI,msl_scalefunction,msl_inst_cfA,msl_inst_cfB,msl_inst_conversionFactor,msl_nbcolors);
            if(msl_display == 0)
            {
                float msl_deltaHue = (-170.0f) / float(msl_nbcolors);
                float4 msl_hsv = float4(0.0f,0.0f,0.0f,0.0f);
                msl_hsv.r = ((170.0f + (float(msl_index) * msl_deltaHue)) / 256.0f);
                msl_hsv.g = 0.996094f;
                msl_hsv.b = 0.996094f;
                max_ToneOpPseudo_HSVtoRGB_4029_38(state,msl_hsv,msl_result);
                msl_result.a = 1.0f;
            }
            else
            {
                int msl_a = 0;
                float msl_delta = 256.0f / float(msl_nbcolors);
                msl_a = int((msl_delta * float(msl_index)) + 0.5f);
                msl_result.r = (float(msl_a) / 256.0f);
                msl_result.g = (float(msl_a) / 256.0f);
                msl_result.b = (float(msl_a) / 256.0f);
                msl_result.a = 1.0f;
            }
        }
    }
    return 0;
}

//
// The following method is the root function of the shader graph
//
float4 max_ToneOpPseudo_1_eval(State state, out FS_OUT eval_out)
{
    // primary output: 
    float4 msl_result;
    max_ToneOpPseudo_main_4029_11(state,__msl_max_ToneOpPseudo_1_env_tex,__msl_max_ToneOpPseudo_1_env_tex_sampler,msl_max_ToneOpPseudo_1_env_tex_props,(state.tex_coord)[0].xy,msl_max_ToneOpPseudo_1_active,msl_max_ToneOpPseudo_1_minimum,msl_max_ToneOpPseudo_1_maximum,msl_max_ToneOpPseudo_1_quantity,msl_max_ToneOpPseudo_1_display,msl_max_ToneOpPseudo_1_physicalscale,msl_max_ToneOpPseudo_1_scalefunction,msl_max_ToneOpPseudo_1_unitsystemused,msl_max_ToneOpPseudo_1_nbcolors,msl_result);
    eval_out = msl_result;
    return msl_result;
}

//
// This function is the main method of the fragment shader.
// It initializes the values in the state structure
// that are used by nodes in the shader graph
// and produces the final result of the shader.
//
FS_OUT fragment_main(
    Vert2frag_in fs_in) : SV_Target
{
    State state;
    state.position = fs_in.position;
    state.normal = normalize(fs_in.normal);
    state.tex_coord = fs_in.tex_coord;
    state.origin = __orthographic ? float3(state.position.x, state.position.y, 0) : 0;
    state.ray_length = __orthographic ? abs(state.position.z) : length(state.position);
    state.direction = __orthographic ? float3(0.0,0.0,-1.0) : state.position/state.ray_length;

    FS_OUT eval_out;  // multiple shader outputs
    float4 primary_out;  // primary shader output
    primary_out = max_ToneOpPseudo_1_eval(state,eval_out);
    FS_OUT fs_out;
    fs_out = primary_out;
    return fs_out;
}

//
// The following define the default technique and pass of the effect.
//
technique11 T0
<
    string Script = "Pass=P0;";
>
{
    pass P0
    <
    string Script = "Draw=Buffer;";
        >
        {
            SetVertexShader(CompileShader(vs_5_0,vertex_main()));
            SetPixelShader(CompileShader(ps_5_0,fragment_main()));
        }
    }

